<?php
/**
 * Core: The CLI class
 *
 * @link        https://o-props.com
 *
 * @package     o-props
 * @subpackage  Core
 * @author      Cédric Bontems <cedric@thewebforge.dev>
 * @since       2.0.0
 * @copyright   Copyright (c) 2022, Cédric Bontems
 * @license     https://www.gnu.org/licenses/gpl-2.0.html  GPLv2 or later
 */

namespace OxyProps\Inc;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WP CLI commands for o-props
 *
 * @see https://wp-cli.org/
 *
 * @author      Cédric Bontems <cedric@thewebforge.dev>
 * @since       2.0.0
 */
class CLI {

	/**
	 * CLI class constructor.
	 *
	 * @see https://make.wordpress.org/cli/handbook/references/internal-api/wp-cli-add-command/
	 *
	 * @since 2.0.0 Creation.
	 * @author Cédric Bontems <cedric@thewebforge.dev>
	 *
	 * @return void
	 */
	public function __construct() {
		if ( defined( 'WP_CLI' ) && \WP_CLI ) {
			\WP_CLI::add_command( 'oxyprops', 'OxyProps\Inc\CLI' );
		}
	}

	/**
	 * Activate license via CLI.
	 *
	 * @param array $args The arguments.
	 * @return void
	 */
	public function activate( $args ) {
		$core       = Init::get_instance( 'core' );
		$registered = $core->oxyprops_cli_activate_license( $args[0], $args[1] );
		$activated  = $registered ? $core->oxyprops_check_wordpress_plugin( $args[0], $args[1], $core->structeezy_license_message, $core->structeezy_response_object ) : false;
		if ( $activated ) {
			\WP_CLI::success( 'DONE! ' . __( 'Your license was successfully activated', 'oxyprops' ) );
		} else {
			\WP_CLI::warning( 'OUCH! ' . __( 'We could not activate your license', 'oxyprops' ) );
		}
	}

	/**
	 * Deactivate license via CLI.
	 *
	 * @return void
	 */
	public function deactivate() {
		$core        = Init::get_instance( 'core' );
		$deactivated = $core->oxyprops_cli_deactivate_license();
		if ( $deactivated ) {
			\WP_CLI::success( 'DONE! ' . __( 'Your license was successfully deactivated', 'oxyprops' ) );
		} else {
			\WP_CLI::warning( 'OUCH! ' . __( 'We could not deactivate your license', 'oxyprops' ) );
		}
	}
}
